/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.builder;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.php.PHPEditorPlugin;
import com.aptana.editor.php.internal.builder.ILibraryListener;
import com.aptana.editor.php.internal.builder.IPHPLibrary;
import com.aptana.editor.php.internal.builder.UserLibrary;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;

public final class LibraryManager {
    private static final String USERLIBRARIES = "com.aptana.editor.php.userLibraries";
    private static final String LIBRARIES_TURNED_OFF = "com.aptana.editor.php.turnedOffLibraries";
    private Set<ILibraryListener> listeners = new HashSet<ILibraryListener>();
    private static LibraryManager instance;
    private Set<String> turnedOff = new HashSet<String>();
    private Set<UserLibrary> userLibraries = new HashSet<UserLibrary>();

    private LibraryManager() {
        String str;
        String string = this.readFromPreferences(LIBRARIES_TURNED_OFF);
        if (string != null && string.length() > 0) {
            String[] split = string.split(",");
            int a = 0;
            while (a < split.length) {
                this.turnedOff.add(split[a].trim());
                ++a;
            }
        }
        if ((str = this.readFromPreferences(USERLIBRARIES)) != null && str.length() != 0) {
            String[] split;
            String[] stringArray = split = str.split("\r");
            int n = split.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                this.userLibraries.add(new UserLibrary(s));
                ++n2;
            }
        }
    }

    public static synchronized LibraryManager getInstance() {
        if (instance == null) {
            instance = new LibraryManager();
        }
        return instance;
    }

    public void setUserLibraries(UserLibrary[] libraries) {
        StringBuilder bld = new StringBuilder();
        UserLibrary[] userLibraryArray = libraries;
        int n = libraries.length;
        int n2 = 0;
        while (n2 < n) {
            UserLibrary userLibrary = userLibraryArray[n2];
            bld.append(userLibrary.toString());
            bld.append('\r');
            ++n2;
        }
        if (bld.length() > 0) {
            bld.deleteCharAt(bld.length() - 1);
        }
        this.saveToPreferences(USERLIBRARIES, bld.toString());
        this.userLibraries = new HashSet<UserLibrary>(Arrays.asList(libraries));
        for (ILibraryListener iLibraryListener : this.listeners) {
            iLibraryListener.userLibrariesChanged(libraries);
        }
    }

    public void addLibraryListener(ILibraryListener libraryListener) {
        this.listeners.add(libraryListener);
    }

    public void removeLibraryListener(ILibraryListener libraryListener) {
        this.listeners.remove(libraryListener);
    }

    public boolean isTurnedOn(IPHPLibrary lib) {
        return !this.turnedOff.contains(lib.getId().trim());
    }

    public IPHPLibrary[] getAllLibraries() {
        return this.userLibraries.toArray(new IPHPLibrary[this.userLibraries.size()]);
    }

    public void setTurnedOff(Set<IPHPLibrary> turnedOff) {
        IPHPLibrary[] libraries;
        StringBuilder bld = new StringBuilder();
        HashSet<IPHPLibrary> currentLibraries = new HashSet<IPHPLibrary>();
        IPHPLibrary[] iPHPLibraryArray = libraries = this.getAllLibraries();
        int n = libraries.length;
        int n2 = 0;
        while (n2 < n) {
            IPHPLibrary l = iPHPLibraryArray[n2];
            if (l.isTurnedOn()) {
                currentLibraries.add(l);
            }
            ++n2;
        }
        HashSet<String> tn = new HashSet<String>();
        for (IPHPLibrary l : turnedOff) {
            bld.append(l.getId());
            tn.add(l.getId().trim());
            bld.append(',');
        }
        if (bld.length() > 0) {
            bld = bld.deleteCharAt(bld.length() - 1);
        }
        this.turnedOff = tn;
        this.saveToPreferences(LIBRARIES_TURNED_OFF, bld.toString());
        HashSet<IPHPLibrary> newLibraries = new HashSet<IPHPLibrary>();
        IPHPLibrary[] iPHPLibraryArray2 = libraries;
        int n3 = libraries.length;
        int n4 = 0;
        while (n4 < n3) {
            IPHPLibrary l = iPHPLibraryArray2[n4];
            if (l.isTurnedOn()) {
                newLibraries.add(l);
            }
            ++n4;
        }
        HashSet<IPHPLibrary> added = new HashSet<IPHPLibrary>();
        HashSet<IPHPLibrary> removed = new HashSet<IPHPLibrary>();
        for (IPHPLibrary l : newLibraries) {
            if (currentLibraries.contains(l)) continue;
            added.add(l);
        }
        for (IPHPLibrary l : currentLibraries) {
            if (newLibraries.contains(l)) continue;
            removed.add(l);
        }
        if (!added.isEmpty() || !removed.isEmpty()) {
            for (ILibraryListener l : this.listeners) {
                l.librariesChanged(added, removed);
            }
        }
    }

    public IPHPLibrary getLibrary(String id) {
        IPHPLibrary[] allLibraries;
        IPHPLibrary[] iPHPLibraryArray = allLibraries = this.getAllLibraries();
        int n = allLibraries.length;
        int n2 = 0;
        while (n2 < n) {
            IPHPLibrary l = iPHPLibraryArray[n2];
            if (l.getId().equals(id)) {
                return l;
            }
            ++n2;
        }
        return null;
    }

    private void saveToPreferences(String key, String value) {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("com.aptana.editor.php");
        prefs.put(key, value);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)"Error saving to the preferences", (Throwable)e);
        }
    }

    private String readFromPreferences(String key) {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("com.aptana.editor.php");
        return prefs.get(key, "");
    }
}

